unit DDisplayTools;
// -----------------------------------------------------------
interface
uses  SysUtils, Graphics, Dialogs, StdCtrls, ExtCtrls, DDisplayGUI, DDisplayQE;
// -----------------------------------------------------------
//  Edit.Text  
function EditTextToFloat (var RqData : double; RqEdit : TEdit) : boolean;
// -----------------------------------------------------------
//   
procedure DDisplayGreate (var RqDDisplay : TDDisplay; RqImage : TImage);
//   
procedure DDisplayDestroy(var RqDDisplay : TDDisplay);
//  /     
procedure OnOffDDisplayItemDraw (RqDDisplay : TDDisplay;
                                 RqOn       : boolean;
                                 OnItemDraw : TIQNotify);
//  /      
procedure OnOffDDisplayAlertItem (RqDDisplay : TDDisplay;
                                 RqOn       : boolean;
                                 OnAlertItem : TIQNotify);
//    
procedure SetDDisplayColor (RqDDisplay    : TDDisplay;
                            RqColorDialog :TColorDialog;
                            RqProp        : byte);
//    
procedure ShowCororIndicators(RqDDisplay   : TDDisplay;
                              RqSTxtBColor : TStaticText;
                              RqSTxtDColor : TStaticText;
                              RqSTxtGColor : TStaticText);
//        
procedure AddPointToDDisplay(RqDDisplay : TDDisplay;
                             RqStyle    : integer;
                             RqPoint    : double);
// -----------------------------------------------------------
implementation
// -----------------------------------------------------------
//  Edit.Text  
function EditTextToFloat (var RqData : double; RqEdit : TEdit) : boolean;
var BufData  : double;
begin
  Result := False;     //   
  try
    BufData := StrToFloat(RqEdit.Text);
    RqEdit.Color := clWindow;
    RqData := BufData;
    Result := True;    //   
  except
    RqEdit.Color := clCream;
    ShowMessage('    ');
  end;
end;
// -----------------------------------------------------------
//   
procedure DDisplayGreate (var RqDDisplay : TDDisplay; RqImage : TImage);
begin
   if not Assigned(RqDDisplay)
   then begin
      try    RqDDisplay := TDDisplay.Create(RqImage);
             RqDDisplay.DMaxCount := 50;
             //   
             RqDDisplay.ShowItemQueue();
      except RqDDisplay := nil;
      end;
   end;
end;
//   
procedure DDisplayDestroy(var RqDDisplay : TDDisplay);
begin
  if Assigned(RqDDisplay)
  then begin
    RqDDisplay.Free;
    RqDDisplay := nil;
  end;
end;
// -----------------------------------------------------------
//  /     
procedure OnOffDDisplayItemDraw (RqDDisplay : TDDisplay;
                                 RqOn       : boolean;
                                 OnItemDraw : TIQNotify);
begin
  if Assigned(RqDDisplay)
  then begin
     if RqOn
     then RqDDisplay.OnDrawItem := OnItemDraw
     else RqDDisplay.OnDrawItem := nil;
  end;
end;
//  /      
procedure OnOffDDisplayAlertItem (RqDDisplay : TDDisplay;
                                 RqOn       : boolean;
                                 OnAlertItem : TIQNotify);
begin
  if Assigned(RqDDisplay)
  then begin
     if RqOn
     then RqDDisplay.OnAlertItem := OnAlertItem
     else RqDDisplay.OnAlertItem := nil;
  end;
end;
// -----------------------------------------------------------
//    
procedure SetDDisplayColor (RqDDisplay    : TDDisplay;
                            RqColorDialog :TColorDialog;
                            RqProp        : byte);
begin
   if Assigned(RqDDisplay)
   then begin
     if RqColorDialog.Execute
     then begin
        case RqProp of
        1 : RqDDisplay.BColor := RqColorDialog.Color;  //   
        2 : RqDDisplay.DColor := RqColorDialog.Color;  //   
        3 : RqDDisplay.GColor := RqColorDialog.Color;  //   
        end;
        RqDDisplay.ShowItemQueue();
     end;
   end;
end;
//    
procedure ShowCororIndicators(RqDDisplay   : TDDisplay;
                              RqSTxtBColor : TStaticText;
                              RqSTxtDColor : TStaticText;
                              RqSTxtGColor : TStaticText);
begin
   if Assigned(RqDDisplay)
   then begin
      //   ,    
      RqSTxtBColor.Color    := RqDDisplay.BColor;
      RqSTxtDColor.Color    := RqDDisplay.DColor;
      RqSTxtGColor.Color    := RqDDisplay.GColor;

   end;
end;
//        
procedure AddPointToDDisplay(RqDDisplay : TDDisplay;
                             RqStyle    : integer;
                             RqPoint    : double);
begin
  if Assigned(RqDDisplay)
  then begin
      RqDDisplay.AddItemToTail(0, RqPoint);  //  
      case RqStyle of
      0 : RqDDisplay.ShowItemQueue();        //  
      1 : RqDDisplay.AnalogShowItemQueue();  //  
      end;
  end;
end;

// -----------------------------------------------------------

end.
